<?php if (!empty($this->itineraries)) : ?>
  <div class="itin itinerator-itineraries <?= $this->attributes['align'] ? 'align' . $this->attributes['align'] : ''; ?> <?= $this->attributes['className'] ?? ''; ?>">
    <div class="container-fluid">
      <div class="row g-4">
        <?php foreach ($this->itineraries as $itinerary) : ?>
          <div class="col-12 col-md-6 mb-4">
            <div class="card h-100">
              <?php
              // Check if $itinerary->hero is set and is an instance of the expected class
              if (!empty($itinerary->hero)) {
              ?>
                <div class="card-img-top">
                <?php echo $itinerary->hero->getImg(null, "img-fluid rounded-top", "style='height: 300px; object-fit:cover;'" ); ?>
                </div>
              <?php
              }
              ?>
              <div class="card-body">
                <h4 class="card-title"><?php echo $itinerary->name ?></h4>
                <div class="d-flex justify-content-between align-items-center mb-3">
                  <span class="itinerator-itinerary-counts">
                    <?php echo pluralize($itinerary->stop_count, "Stop", true) ?>
                    |
                    <?php echo pluralize($itinerary->leg_count, "Day", true) ?>
                  </span>
                  <span class="itinerator-itinerary-region-name">
                    <?php echo $itinerary->region_name ?>
                  </span>
                </div>
                <p class="card-text"><?php echo $this->parse_markdown($itinerary->description) ?></p>
                <div class="d-grid gap-2">
                  <a href="/itinerary/<?php echo $itinerary->slug ?>" class="btn btn-primary">Explore this itinerary</a>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
<?php endif ?>
